/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.datagen;

import javax.annotation.Nonnull;
import mrthomas20121.tinkers_reforged.init.TinkersReforgedModifiers;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialStatsDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialTraitDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class ReforgedMaterials
extends AbstractMaterialDataProvider {
    public static final MaterialId duralumin = ReforgedMaterials.createMaterial("duralumin");
    public static final MaterialId electrical_copper = ReforgedMaterials.createMaterial("electrical_copper");
    public static final MaterialId lavium = ReforgedMaterials.createMaterial("lavium");
    public static final MaterialId qivium = ReforgedMaterials.createMaterial("qivium");
    public static final MaterialId gausum = ReforgedMaterials.createMaterial("gausum");
    public static final MaterialId felsteel = ReforgedMaterials.createMaterial("felsteel");
    public static final MaterialId chorus_metal = ReforgedMaterials.createMaterial("chorus_metal");
    public static final MaterialId kepu = ReforgedMaterials.createMaterial("kepu");
    public static final MaterialId durasteel = ReforgedMaterials.createMaterial("durasteel");
    public static final MaterialId crusteel = ReforgedMaterials.createMaterial("crusteel");
    public static final MaterialId wavy = ReforgedMaterials.createMaterial("wavy");
    public static final MaterialId yokel = ReforgedMaterials.createMaterial("yokel");

    private static MaterialId createMaterial(String name) {
        return new MaterialId(new ResourceLocation("tinkers_reforged", name));
    }

    public ReforgedMaterials(DataGenerator gen) {
        super(gen);
    }

    protected void addMaterials() {
        this.addMaterial(duralumin, 3, 1, false);
        this.addMaterial(electrical_copper, 3, 0, false);
        this.addMaterial(lavium, 4, 1, false);
        this.addMaterial(qivium, 4, 2, false);
        this.addMaterial(gausum, 4, 1, false);
        this.addMaterial(felsteel, 4, 1, false);
        this.addMaterial(chorus_metal, 4, 1, false);
        this.addMaterial(kepu, 4, 1, false);
        this.addMaterial(durasteel, 4, 3, false);
        this.addMaterial(crusteel, 4, 1, false);
        this.addMaterial(wavy, 4, 3, false);
        this.addMaterial(yokel, 4, 2, false);
    }

    @Nonnull
    public String m_6055_() {
        return "Tinkers Reforged Materials";
    }

    public static class ReforgedMaterialStats
    extends AbstractMaterialStatsDataProvider {
        public ReforgedMaterialStats(DataGenerator gen, AbstractMaterialDataProvider materials) {
            super(gen, materials);
        }

        @Nonnull
        public String m_6055_() {
            return "Tinkers Reforged Material Stats";
        }

        protected void addMaterialStats() {
            this.addMaterialStats(qivium, new IMaterialStats[]{new HeadMaterialStats(800, 5.0f, (Tier)Tiers.DIAMOND, 5.0f), HandleMaterialStats.DEFAULT.withDurability(1.05f).withMiningSpeed(1.05f).withAttackSpeed(1.05f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(lavium, new IMaterialStats[]{new HeadMaterialStats(800, 7.5f, (Tier)Tiers.DIAMOND, 2.25f), HandleMaterialStats.DEFAULT.withDurability(1.05f).withMiningSpeed(1.05f).withAttackSpeed(1.05f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(gausum, new IMaterialStats[]{new HeadMaterialStats(1200, 7.4f, (Tier)Tiers.DIAMOND, 4.0f), HandleMaterialStats.DEFAULT.withDurability(2.0f).withMiningSpeed(1.05f).withAttackSpeed(1.05f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(felsteel, new IMaterialStats[]{new HeadMaterialStats(1300, 6.0f, (Tier)Tiers.NETHERITE, 4.0f), HandleMaterialStats.DEFAULT.withDurability(2.01f).withMiningSpeed(1.01f).withAttackSpeed(1.2f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(chorus_metal, new IMaterialStats[]{new HeadMaterialStats(900, 5.0f, (Tier)Tiers.NETHERITE, 5.0f), HandleMaterialStats.DEFAULT.withDurability(2.01f).withMiningSpeed(1.01f).withAttackSpeed(1.2f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(kepu, new IMaterialStats[]{new HeadMaterialStats(600, 4.0f, (Tier)Tiers.NETHERITE, 6.0f), HandleMaterialStats.DEFAULT.withDurability(2.01f).withMiningSpeed(1.01f).withAttackSpeed(1.2f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(duralumin, new IMaterialStats[]{new HeadMaterialStats(500, 7.0f, (Tier)Tiers.DIAMOND, 3.0f), HandleMaterialStats.DEFAULT.withDurability(1.4f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(electrical_copper, new IMaterialStats[]{new HeadMaterialStats(300, 6.0f, (Tier)Tiers.DIAMOND, 2.0f), HandleMaterialStats.DEFAULT.withDurability(1.2f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(durasteel, new IMaterialStats[]{new HeadMaterialStats(1200, 6.0f, (Tier)Tiers.NETHERITE, 7.0f), HandleMaterialStats.DEFAULT.withDurability(1.01f).withAttackSpeed(1.02f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(crusteel, new IMaterialStats[]{new HeadMaterialStats(800, 6.6f, (Tier)Tiers.NETHERITE, 4.25f), HandleMaterialStats.DEFAULT.withDurability(1.05f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(wavy, new IMaterialStats[]{new HeadMaterialStats(1000, 6.9f, (Tier)Tiers.NETHERITE, 5.25f), HandleMaterialStats.DEFAULT.withDurability(1.05f), ExtraMaterialStats.DEFAULT});
            this.addMaterialStats(yokel, new IMaterialStats[]{new HeadMaterialStats(1100, 5.55f, (Tier)Tiers.DIAMOND, 5.55f), HandleMaterialStats.DEFAULT.withDurability(1.05f), ExtraMaterialStats.DEFAULT});
        }
    }

    public static class ReforgedTraits
    extends AbstractMaterialTraitDataProvider {
        public ReforgedTraits(DataGenerator gen, AbstractMaterialDataProvider materials) {
            super(gen, materials);
        }

        protected void addMaterialTraits() {
            this.addDefaultTraits(qivium, new LazyModifier[]{TinkersReforgedModifiers.qivium_blazing_fire});
            this.addDefaultTraits(lavium, new LazyModifier[]{TinkersReforgedModifiers.lavium_aridzone});
            this.addDefaultTraits(duralumin, new LazyModifier[]{TinkersReforgedModifiers.duralumin_ultra_durable});
            this.addDefaultTraits(electrical_copper, new LazyModifier[]{TinkersReforgedModifiers.electrical_copper_electro_web});
            this.addDefaultTraits(gausum, new LazyModifier[]{TinkersReforgedModifiers.gausum_titanic_damage});
            this.addDefaultTraits(felsteel, new LazyModifier[]{TinkersReforgedModifiers.felsteel_fel_debris});
            this.addDefaultTraits(chorus_metal, new LazyModifier[]{TinkersReforgedModifiers.chorus_metal_levitating_blob});
            this.addDefaultTraits(kepu, new LazyModifier[]{TinkersReforgedModifiers.kepu_damage_lock});
            this.addDefaultTraits(durasteel, new LazyModifier[]{TinkersReforgedModifiers.durasteel_adapting});
            this.addDefaultTraits(wavy, new LazyModifier[]{TinkersReforgedModifiers.spore_shot});
            this.addDefaultTraits(crusteel, new LazyModifier[]{TinkersReforgedModifiers.giant_cells});
            this.addDefaultTraits(yokel, new LazyModifier[]{TinkersReforgedModifiers.terra});
        }

        @Nonnull
        public String m_6055_() {
            return "Tinkers Reforged Material Traits";
        }
    }
}

